/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.VWBaseStepPropertiesPanel;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class VWReadOnlyStepPropertiesPanel
extends VWBaseStepPropertiesPanel {
    private static final int TABLE_START1 = 0;
    private static final int TABLE_START2 = 1;
    private static final int TABLE_HEADER = 2;
    private static final int TABLE_ROW = 3;
    private static final int TABLE_END1 = 4;
    private static final int TABLE_END2 = 5;
    private static final int TYPE_SECTION = 0;
    private static final int TYPE_HEADER = 1;
    private static final int TYPE_ROW1 = 2;
    private static final int TYPE_ROW2 = 3;
    private static final int TYPE_ROW3 = 4;
    private static final int TYPE_ROW4 = 5;
    private static final int TYPE_ROW5 = 6;
    private static final int TYPE_ROW6 = 7;
    private JTextPane m_propertiesPane = null;

    public void displayHelpPage() {
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        this.m_currentMapNode = vwMapNode;
        this.displayReadOnlyProperties(vwMapNode);
    }

    public void releaseReferences() {
        this.m_propertiesPane = null;
        super.releaseReferences();
    }

    protected void initUIControls() {
        this.setLayout(new BorderLayout());
        this.m_propertiesPane = new JTextPane();
        this.m_propertiesPane.setContentType("text/html");
        this.m_propertiesPane.setEditable(false);
        this.add((Component)new JScrollPane(this.m_propertiesPane), "Center");
        this.displayReadOnlyProperties(this.m_currentMapNode);
    }

    private void appendBlankline(StringBuffer buffer) {
        this.appendTextLine(buffer, "", 2);
    }

    private void appendTextLine(StringBuffer buffer, String newLine, int nType) {
        if (buffer == null || newLine == null) {
            return;
        }
        switch (nType) {
            case 0: {
                buffer.append("<tr><td width='100%'><font size='4'><b>");
                buffer.append(newLine + "</b></font></td></tr>");
                break;
            }
            case 1: {
                buffer.append("<tr><td width='100%' bgcolor='#dcddde'><font color='#000000'>");
                buffer.append(newLine + "</font></td></tr>");
                break;
            }
            case 2: {
                buffer.append("<tr><td width='100%'>&nbsp;" + newLine + "</td></tr>");
                break;
            }
            case 3: {
                buffer.append("<tr><td width='100%'>&nbsp;&nbsp;&nbsp;" + newLine + "</td></tr>");
                break;
            }
            case 4: {
                buffer.append("<tr><td width='100%'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + newLine + "</td></tr>");
                break;
            }
            case 5: {
                buffer.append("<tr><td width='100%'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + newLine + "</td></tr>");
                break;
            }
            case 6: {
                buffer.append("<tr><td width='100%'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + newLine + "</td></tr>");
                break;
            }
            case 7: {
                buffer.append("<tr><td width='100%'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + newLine + "</td></tr>");
            }
        }
    }

    private void appendTableLine(StringBuffer buffer, String[] items, int nType) {
        if (buffer == null) {
            return;
        }
        switch (nType) {
            case 0: {
                buffer.append("<html><body>");
                buffer.append("<table border='0' width='100%'>");
                break;
            }
            case 1: {
                buffer.append("<table align='center' border=1  width='95%'>");
                break;
            }
            case 2: {
                buffer.append("<tr>");
                if (items != null && items.length > 0) {
                    for (int i = 0; i < items.length; ++i) {
                        buffer.append("<th align='left' bgcolor='#bbbbbb' nowrap><font color='#000000'>");
                        buffer.append(items[i] + "</font></th>");
                    }
                }
                buffer.append("</tr>");
                break;
            }
            case 3: {
                buffer.append("<tr>");
                if (items != null && items.length > 0) {
                    for (int i = 0; i < items.length; ++i) {
                        buffer.append("<td bgcolor='#ffffff' nowrap><font color='#000000'>");
                        buffer.append(items[i] + "</font></td>");
                    }
                }
                buffer.append("</tr>");
                break;
            }
            case 4: {
                buffer.append("</table>");
                buffer.append("</body></html>");
                break;
            }
            case 5: {
                buffer.append("</table>");
            }
        }
    }

    private void displayReadOnlyProperties(VWMapNode mapNode) {
        try {
            StringBuffer buffer = new StringBuffer();
            this.appendTableLine(buffer, null, 0);
            int nStepType = VWStepUtils.getStepType(mapNode);
            switch (nStepType) {
                case 0: {
                    this.addGeneralStepProperties(buffer, true);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.addGeneralStepProperties(buffer, false);
                    break;
                }
                case 13: 
                case 14: {
                    this.addComponentStepProperties(buffer);
                    break;
                }
                case 9: 
                case 10: {
                    this.addSubmapStepProperties(buffer);
                    break;
                }
                case 11: 
                case 12: {
                    this.addSystemStepProperties(buffer);
                }
            }
            this.appendTableLine(buffer, null, 4);
            this.m_propertiesPane.removeAll();
            this.m_propertiesPane.setText(buffer.toString());
            this.m_propertiesPane.setCaretPosition(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addGeneralStepProperties(StringBuffer buffer, boolean bIsLaunchStep) throws Exception {
        if (buffer == null) {
            return;
        }
        this.addGeneralInfo(buffer, bIsLaunchStep);
        this.addParameters(buffer);
        this.addAssignments(buffer, bIsLaunchStep);
        this.addAttributes(buffer);
        this.addRules(buffer);
        this.addRouting(buffer);
    }

    private void addComponentStepProperties(StringBuffer buffer) throws Exception {
        if (buffer == null) {
            return;
        }
        this.appendTextLine(buffer, VWResource.s_general, 0);
        this.appendTextLine(buffer, VWResource.s_descriptionColon, 1);
        String description = this.m_currentMapNode.getDescription();
        if (description != null && description.length() > 0) {
            description = VWStringUtils.toXMLString(description, true);
            description = VWStringUtils.replaceAll(description, "&#10;", "<br>");
            this.appendTextLine(buffer, description, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        if (this.m_currentMapNode instanceof VWCompoundStepDefinition) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operations), 1);
            VWInstructionDefinition[] instructionDefs = ((VWCompoundStepDefinition)this.m_currentMapNode).getInstructions();
            if (instructionDefs != null && instructionDefs.length > 0) {
                boolean bHasOperation = false;
                for (int i = 0; i < instructionDefs.length; ++i) {
                    VWParameterDefinition[] parameterDefs;
                    VWOperationDefinition operationDef;
                    if (!(instructionDefs[i] instanceof VWSimpleInstruction) || instructionDefs[i].getAction() != 23) continue;
                    if (!bHasOperation) {
                        bHasOperation = true;
                    }
                    String operationName = VWInstruction.ExecuteInstructionGetOperationName(instructionDefs[i]);
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operationName) + operationName, 2);
                    String componentQueueName = VWInstruction.ExecuteInstructionGetQueueName(instructionDefs[i]);
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_component) + " " + componentQueueName, 2);
                    this.appendTextLine(buffer, VWResource.s_parametersColon, 2);
                    VWQueueDefinition queueDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueDefinition(componentQueueName);
                    if (queueDef != null && (operationDef = queueDef.getOperation(operationName)) != null && (parameterDefs = operationDef.getParameterDefinitions()) != null && parameterDefs.length > 0) {
                        String[] parameterValues = VWInstruction.ExecuteInstructionGetParameterList(instructionDefs[i]);
                        for (int j = 0; j < parameterDefs.length; ++j) {
                            String name = parameterDefs[j].getName();
                            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_name) + name, 3);
                            int nType = parameterDefs[j].getDataType();
                            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_type) + " " + VWFieldType.getLocalizedString(nType), 3);
                            int nMode = parameterDefs[j].getMode();
                            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_mode) + " " + VWModeType.getLocalizedString(nMode), 3);
                            String value = VWResource.s_htmlNone;
                            if (j < parameterValues.length) {
                                value = parameterValues[j];
                            }
                            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_value) + " " + value, 3);
                            if (j >= parameterDefs.length - 1) continue;
                            this.appendBlankline(buffer);
                        }
                    }
                    if (i >= instructionDefs.length - 1) continue;
                    this.appendBlankline(buffer);
                }
                if (!bHasOperation) {
                    this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
                }
            } else {
                this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            }
        }
        this.addAttributes(buffer);
        this.addRules(buffer);
        this.addRouting(buffer);
    }

    private void addSubmapStepProperties(StringBuffer buffer) throws Exception {
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_general), 0);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_instructions), 1);
        String description = this.m_currentMapNode.getDescription();
        if (description != null && description.length() > 0) {
            description = VWStringUtils.toXMLString(description, true);
            description = VWStringUtils.replaceAll(description, "&#10;", "<br>");
            this.appendTextLine(buffer, description, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        this.appendTextLine(buffer, VWResource.s_submap, 1);
        String submapName = VWStepUtils.getCalledMapName(this.m_currentMapNode);
        if (submapName != null && submapName.length() > 0) {
            this.appendTextLine(buffer, submapName, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        this.addAttributes(buffer);
        this.addRules(buffer);
        this.addRouting(buffer);
    }

    private void addSystemStepProperties(StringBuffer buffer) throws Exception {
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_general), 0);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_instructions), 1);
        String description = this.m_currentMapNode.getDescription();
        if (description != null && description.length() > 0) {
            description = VWStringUtils.toXMLString(description, true);
            description = VWStringUtils.replaceAll(description, "&#10;", "<br>");
            this.appendTextLine(buffer, description, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        this.addSystemStepFunctions(buffer);
        this.addAttributes(buffer);
        this.addRules(buffer);
        this.addRouting(buffer);
    }

    private void addGeneralInfo(StringBuffer buffer, boolean bIsLaunchStep) throws Exception {
        this.appendTextLine(buffer, VWResource.s_general, 0);
        this.appendTextLine(buffer, VWResource.s_instructions, 1);
        String instructions = this.m_currentMapNode.getDescription();
        if (instructions != null && instructions.length() > 0) {
            instructions = VWStringUtils.toXMLString(instructions, true);
            instructions = VWStringUtils.replaceAll(instructions, "&#10;", "<br>");
            this.appendTextLine(buffer, instructions, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        this.appendTextLine(buffer, VWResource.s_description, 1);
        String description = this.m_currentMapNode.getDocumentation();
        if (description != null && description.length() > 0) {
            description = VWStringUtils.toXMLString(description, true);
            description = VWStringUtils.replaceAll(description, "&#10;", "<br>");
            this.appendTextLine(buffer, description, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        if (this.m_currentMapNode instanceof VWStepDefinition) {
            VWStepDefinition stepDef = (VWStepDefinition)this.m_currentMapNode;
            if (!bIsLaunchStep) {
                this.appendTextLine(buffer, VWResource.s_workQueue, 1);
                String name = stepDef.getQueueName();
                if (name != null && name.length() > 0) {
                    this.appendTextLine(buffer, name, 2);
                } else {
                    this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
                }
                this.appendTextLine(buffer, VWResource.s_participants, 1);
                VWParticipant[] participants = stepDef.getParticipants();
                if (participants != null && participants.length > 0) {
                    StringBuffer participantBuffer = new StringBuffer();
                    for (int i = 0; i < participants.length; ++i) {
                        if (i > 0) {
                            participantBuffer.append(", ");
                        }
                        participantBuffer.append(participants[i].getParticipantName());
                    }
                    this.appendTextLine(buffer, participantBuffer.toString(), 2);
                } else {
                    this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
                }
                if (stepDef.getIgnoreInvalidUsers()) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_ignoreMissingParticipants) + VWResource.s_true, 3);
                } else {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_ignoreMissingParticipants) + VWResource.s_false, 3);
                }
                this.appendTextLine(buffer, VWResource.s_participantPrivileges, 1);
                name = stepDef.getCanReassign() ? VWResource.s_colon.toString(VWResource.s_allowReassign) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowReassign) + VWResource.s_no;
                this.appendTextLine(buffer, name, 2);
                name = stepDef.getCanViewStatus() ? VWResource.s_colon.toString(VWResource.s_allowViewStatus) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowViewStatus) + VWResource.s_no;
                this.appendTextLine(buffer, name, 2);
                name = stepDef.getCanViewHistory() ? VWResource.s_colon.toString(VWResource.s_allowViewHistory) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowViewHistory) + VWResource.s_no;
                this.appendTextLine(buffer, name, 2);
                if (!bIsLaunchStep) {
                    this.appendTextLine(buffer, VWResource.s_deadline, 1);
                    long minutes = stepDef.getDeadline();
                    if (minutes <= 0L) {
                        String deadlineExp = stepDef.getDeadlineExpr();
                        name = VWResource.s_colon.toString(VWResource.s_deadlineWithin) + (deadlineExp != null && deadlineExp.length() > 0 ? deadlineExp : VWResource.s_htmlNone);
                    } else {
                        name = VWResource.s_colon.toString(VWResource.s_deadlineWithin) + this.convertTime(minutes);
                    }
                    this.appendTextLine(buffer, name, 2);
                    long reminder = stepDef.getReminder();
                    name = reminder <= 0L ? VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + VWResource.s_htmlNone : VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + this.convertTime(reminder);
                    this.appendTextLine(buffer, name, 2);
                    String strDeadlineSubMap = stepDef.getDeadlineMap();
                    if (strDeadlineSubMap != null && strDeadlineSubMap.length() > 0) {
                        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_deadlineSubmap) + strDeadlineSubMap, 2);
                    } else {
                        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_deadlineSubmap) + VWResource.s_htmlNone, 2);
                    }
                }
            }
            this.appendTextLine(buffer, VWResource.s_stepProcessor, 1);
            String sRequestedInterface = stepDef.getRequestedInterface();
            if (sRequestedInterface != null && sRequestedInterface.length() > 0) {
                this.appendTextLine(buffer, sRequestedInterface, 2);
            } else {
                this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            }
        }
    }

    private String convertTime(long minutes) {
        StringBuffer buffer = new StringBuffer();
        if (minutes >= 10080L) {
            buffer.append(Long.toString(minutes / 10080L) + " " + VWResource.s_weeks);
            minutes %= 10080L;
        }
        if (minutes >= 1440L) {
            buffer.append(" " + Long.toString(minutes / 1440L) + " " + VWResource.s_days);
            minutes %= 1440L;
        }
        if (minutes >= 60L) {
            buffer.append(" " + Long.toString(minutes / 60L) + " " + VWResource.s_hours);
            minutes %= 60L;
        }
        if (minutes > 0L) {
            buffer.append(" " + Long.toString(minutes) + " " + VWResource.s_minutes);
        }
        return buffer.toString();
    }

    private void addParameters(StringBuffer buffer) throws Exception {
        VWStepDefinition stepDef;
        VWParameterDefinition[] parameters;
        if (this.m_currentMapNode instanceof VWStepDefinition && (parameters = (stepDef = (VWStepDefinition)this.m_currentMapNode).getParameterDefinitions()) != null && parameters.length > 0) {
            this.appendTextLine(buffer, VWResource.s_parameters, 0);
            int ix = 0;
            for (int i = 0; i < parameters.length; ++i) {
                this.appendTextLine(buffer, Integer.toString(++ix) + ". " + parameters[i].getName(), 1);
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_accessRights) + VWModeType.getLocalizedString(parameters[i].getMode()), 2);
                String prompt = parameters[i].getDescription();
                if (prompt == null || prompt.length() < 1) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_prompt) + VWResource.s_htmlNone, 2);
                    continue;
                }
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_prompt) + parameters[i].getDescription(), 2);
            }
        }
    }

    private void addAssignments(StringBuffer buffer, boolean bIsLaunchStep) throws Exception {
        if (this.m_currentMapNode instanceof VWStepDefinition) {
            String expression;
            int i;
            String[][] assignments;
            String sMilestone;
            VWStepDefinition stepDef = (VWStepDefinition)this.m_currentMapNode;
            this.appendTextLine(buffer, VWResource.s_assignments, 0);
            if (!bIsLaunchStep) {
                this.appendTextLine(buffer, VWResource.s_beforeExecution, 1);
                sMilestone = stepDef.getPreMilestone();
                if (sMilestone != null && sMilestone.length() > 0) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_milestone) + sMilestone, 2);
                } else {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_milestone) + VWResource.s_htmlNone, 2);
                }
                assignments = stepDef.getPreAssignments();
                if (assignments != null) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_fieldAssignments), 2);
                    for (i = 0; i < assignments.length; ++i) {
                        this.appendTextLine(buffer, Integer.toString(i + 1) + ". " + VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 3);
                        expression = VWStringUtils.toXMLString(assignments[i][1], true);
                        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_expression) + expression, 4);
                    }
                } else {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_htmlNone, 2);
                }
            }
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_afterCompletion), 1);
            sMilestone = stepDef.getPostMilestone();
            if (sMilestone != null && sMilestone.length() > 0) {
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_milestone) + sMilestone, 2);
            } else {
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_milestone) + VWResource.s_htmlNone, 2);
            }
            assignments = stepDef.getPostAssignments();
            if (assignments != null) {
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_fieldAssignments), 2);
                for (i = 0; i < assignments.length; ++i) {
                    this.appendTextLine(buffer, Integer.toString(i + 1) + ". " + VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 3);
                    expression = VWStringUtils.toXMLString(assignments[i][1], true);
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_expression) + expression, 4);
                }
            } else {
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_htmlNone, 2);
            }
        }
    }

    private void addAttributes(StringBuffer buffer) throws Exception {
        String[] attributeNames;
        VWAttributeInfo attributeInfo = this.m_currentMapNode.getAttributeInfo();
        if (attributeInfo != null && (attributeNames = attributeInfo.getAttributeNames()) != null && attributeNames.length > 0) {
            boolean bDisplayedHeader = false;
            for (int i = 0; i < attributeNames.length; ++i) {
                String name = attributeNames[i];
                if (name.length() <= 2 || name.substring(1, 2).compareTo("F_") == 0 || name.compareTo("UI_StepType") == 0) continue;
                String[] names = new String[4];
                if (!bDisplayedHeader) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_attributes), 0);
                    this.appendTableLine(buffer, null, 1);
                    names[0] = VWResource.s_name;
                    names[1] = VWResource.s_type;
                    names[2] = VWResource.s_array;
                    names[3] = VWResource.s_value;
                    this.appendTableLine(buffer, names, 2);
                    bDisplayedHeader = true;
                }
                Object obj = attributeInfo.getFieldValue(name);
                names[0] = name;
                names[1] = VWFieldType.getLocalizedString(attributeInfo.getFieldType(name));
                names[2] = attributeInfo.isFieldArray(name) ? VWResource.s_yes : VWResource.s_no;
                names[3] = this.getValueString(obj);
                this.appendTableLine(buffer, names, 3);
            }
            if (bDisplayedHeader) {
                this.appendTableLine(buffer, null, 5);
            }
        }
    }

    public String getValueString(Object valueObj) {
        String value = "";
        if (valueObj instanceof Boolean) {
            value = ((Boolean)valueObj).toString();
        } else if (valueObj instanceof Integer) {
            value = ((Integer)valueObj).toString();
        } else if (valueObj instanceof Double) {
            value = ((Double)valueObj).toString();
        } else if (valueObj instanceof String) {
            value = (String)valueObj;
        } else if (valueObj instanceof Object[]) {
            value = this.arrayToString((Object[])valueObj);
        }
        return value;
    }

    private String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer("{");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(array[i].toString());
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private void addRules(StringBuffer buffer) throws Exception {
        int ix;
        String[] ruleSetNames;
        this.appendTextLine(buffer, VWResource.s_rules, 0);
        int stepType = VWStepUtils.getStepType(this.m_currentMapNode);
        if (stepType != 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_beforeExecution), 1);
            ruleSetNames = this.m_currentMapNode.getRuleSetNames(0);
            if (ruleSetNames != null && ruleSetNames.length > 0) {
                for (ix = 0; ix < ruleSetNames.length; ++ix) {
                    this.appendTextLine(buffer, Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2);
                }
            } else {
                this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            }
        }
        if (VWStepUtils.isGeneralStep(stepType) || VWStepUtils.isStartGeneralStep(stepType)) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_onSave), 1);
            ruleSetNames = this.m_currentMapNode.getRuleSetNames(1);
            if (ruleSetNames != null && ruleSetNames.length > 0) {
                for (ix = 0; ix < ruleSetNames.length; ++ix) {
                    this.appendTextLine(buffer, Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2);
                }
            } else {
                this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            }
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_afterCompletion), 1);
        ruleSetNames = this.m_currentMapNode.getRuleSetNames(2);
        if (ruleSetNames != null && ruleSetNames.length > 0) {
            for (ix = 0; ix < ruleSetNames.length; ++ix) {
                this.appendTextLine(buffer, Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
    }

    private void addRouting(StringBuffer buffer) throws Exception {
        this.appendTextLine(buffer, VWResource.s_routing, 0);
        this.addResponse(buffer);
        this.addInOutRoutes(buffer);
    }

    private void addResponse(StringBuffer buffer) throws Exception {
        if (this.m_currentMapNode instanceof VWStepDefinition) {
            VWStepDefinition stepDef = (VWStepDefinition)this.m_currentMapNode;
            this.appendTextLine(buffer, VWResource.s_responsesColon, 1);
            String[] responses = stepDef.getResponses();
            if (responses != null && responses.length > 0) {
                String sResponses = null;
                for (int i = 0; i < responses.length; ++i) {
                    sResponses = sResponses == null ? responses[i] : sResponses + ", " + responses[i];
                }
                this.appendTextLine(buffer, sResponses, 2);
            } else {
                this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            }
        }
    }

    private void addInOutRoutes(StringBuffer buffer) throws Exception {
        String aLine = null;
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_IncomingRoutingInfo), 1);
        aLine = this.m_currentMapNode.getJoinType() == 1 ? VWResource.s_collectorStepType : VWResource.s_nonCollectorStepType;
        this.appendTextLine(buffer, aLine, 2);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_outgoingRouting), 1);
        int splitType = this.m_currentMapNode.getSplitType();
        if (splitType == 1) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_stepRouteAllTrue, 2);
        } else if (splitType == 2) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_stepRouteFirstTrue, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_htmlNone, 2);
        }
        VWRouteDefinition[] routes = this.m_currentMapNode.getNextRoutes();
        if (routes != null && routes.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_evaluationOrder), 2);
            String sEvaluationOrder = null;
            for (int i = 0; i < routes.length; ++i) {
                String routeName = routes[i].getName();
                routeName = routeName == null || routeName.length() <= 0 ? VWResource.s_blankRouteLabel.toString(Integer.toString(i + 1)) : VWStringUtils.toXMLString(routeName, true);
                sEvaluationOrder = sEvaluationOrder == null ? routeName : sEvaluationOrder + ", " + routeName;
            }
            this.appendTextLine(buffer, sEvaluationOrder, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_evaluationOrder) + VWResource.s_htmlNone, 2);
        }
    }

    private void addSystemStepFunctions(StringBuffer buffer) throws Exception {
        this.appendTextLine(buffer, VWResource.s_functions, 0);
        VWCompoundStepDefinition compoundStepDef = (VWCompoundStepDefinition)this.m_currentMapNode;
        VWInstructionDefinition[] instructionDefs = compoundStepDef.getInstructions();
        if (instructionDefs == null) {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
            return;
        }
        block20: for (int i = 0; i < instructionDefs.length; ++i) {
            int nActionType = instructionDefs[i].getAction();
            this.appendTextLine(buffer, Integer.toString(i + 1) + ". " + VWFunctionStrings.getLocalizedString(nActionType), 1);
            switch (nActionType) {
                case 0: {
                    this.addAssignmentInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 1: {
                    this.addBeginTimerInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 5: {
                    this.addCallInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 6: {
                    this.addCreateInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 37: {
                    this.addDBExecuteInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 7: {
                    this.addDelayInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 9: {
                    this.addEndTimerInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 23: {
                    continue block20;
                }
                case 38: {
                    this.addLogFunction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 13: {
                    this.addResumeTimerInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 14: {
                    this.addReturnInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 29: {
                    this.addRollbackCheckpointInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 16: {
                    this.addSuspendTimerInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 19: {
                    this.addWaitForConditionInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 39: {
                    this.addInvokeInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 40: {
                    this.addReceiveInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 41: {
                    this.addReplyInstruction(buffer, instructionDefs[i]);
                    continue block20;
                }
                case 8: 
                case 17: 
                case 24: 
                case 27: 
                case 28: 
                case 42: {
                    this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
                }
            }
        }
    }

    private void addAssignmentInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String[][] assignments = VWInstruction.AssignInstructionGetAssignment(instDef);
        if (assignments != null && assignments.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_assignments), 3);
            this.appendTableLine(buffer, null, 1);
            String[] names = new String[]{VWResource.s_name, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (int i = 0; i < assignments.length; ++i) {
                names[0] = assignments[i][0];
                names[1] = VWStringUtils.toXMLString(assignments[i][1], true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
    }

    private void addBeginTimerInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String strText = VWInstruction.BeginTimerInstructionGetName(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + strText, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_htmlNone, 3);
        }
        strText = VWInstruction.BeginTimerInstructionGetExpirationTime(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_expirationTime) + strText, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_expirationTime) + VWResource.s_htmlNone, 3);
        }
        strText = VWInstruction.BeginTimerInstructionGetSubmapName(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_submap) + strText, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_submap) + VWResource.s_htmlNone, 3);
        }
    }

    private void addCallInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sSubmap = VWInstruction.CallInstructionGetSubmap(instDef);
        if (sSubmap != null && sSubmap.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_submap) + sSubmap, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_submap) + VWResource.s_htmlNone, 3);
        }
    }

    private void addCreateInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sWorkClass = VWInstruction.CreateInstructionGetWorkClass(instDef);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_workflowName) + sWorkClass, 3);
        String[][] assignments = VWInstruction.CreateInstructionGetAssignments(instDef);
        if (assignments != null && assignments.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_assignments), 3);
            this.appendTableLine(buffer, null, 1);
            String[] names = new String[]{VWResource.s_name, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (int i = 0; i < assignments.length; ++i) {
                names[0] = assignments[i][0];
                names[1] = VWStringUtils.toXMLString(assignments[i][1], true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
    }

    private void addDelayInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sDelayExpression = VWInstruction.DelayInstructionGetTime(instDef);
        if (sDelayExpression != null && sDelayExpression.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_delayExpression) + sDelayExpression, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_delayExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addEndTimerInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sEndTimer = VWInstruction.EndTimerInstructionGetTime(instDef);
        if (sEndTimer != null && sEndTimer.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sEndTimer, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addResumeTimerInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sResumeTimer = VWInstruction.ResumeTimerInstructionGetTime(instDef);
        if (sResumeTimer != null && sResumeTimer.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sResumeTimer, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addReturnInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sRetryOption = VWInstruction.ReturnInstructionGetRetryOption(instDef);
        if (sRetryOption != null && sRetryOption.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_returnExpression) + sRetryOption, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_returnExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addDBExecuteInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String dbName = VWInstruction.DatabaseExecuteInstructionGetDatabaseName(instDef);
        if (dbName.length() > 0) {
            dbName = dbName.substring(1, dbName.length() - 1);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_databaseConnectionAlias) + dbName, 4);
        String storedProcName = VWInstruction.DatabaseExecuteInstructionGetStoredProcName(instDef);
        if (storedProcName.length() > 0) {
            storedProcName = storedProcName.substring(1, storedProcName.length() - 1);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_procedureName) + storedProcName, 4);
        String[] parameters = VWInstruction.DatabaseExecuteInstructionGetParameters(instDef);
        if (parameters != null && parameters.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_parameters), 4);
            String strParameterList = null;
            for (int i = 0; i < parameters.length; ++i) {
                strParameterList = strParameterList == null ? parameters[i] : strParameterList + ", " + parameters[i];
            }
            this.appendTextLine(buffer, strParameterList, 4);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_parameters) + VWResource.s_htmlNone, 4);
        }
    }

    private void addLogFunction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String eventTypeExpression = VWInstruction.LogInstructionGetEventType(instDef);
        if (eventTypeExpression != null && eventTypeExpression.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_eventTypeExpression) + eventTypeExpression, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_eventTypeExpression) + VWResource.s_htmlNone, 3);
        }
        String eventMessageExpression = VWInstruction.LogInstructionGetEventMessage(instDef);
        if (eventMessageExpression != null && eventMessageExpression.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_eventMessageExpression) + eventMessageExpression, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_eventMessageExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addRollbackCheckpointInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String redoFlag = VWInstruction.RollBackCheckPointInstructionGetReDoFlag(instDef);
        if (redoFlag != null && redoFlag.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_resumeProcessingExpression) + redoFlag, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_resumeProcessingExpression) + VWResource.s_htmlNone, 3);
        }
        String submap = VWInstruction.RollBackCheckPointInstructionGetMap(instDef);
        if (submap != null && submap.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_map) + submap, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_map) + VWResource.s_htmlNone, 3);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_nonRollBackFields), 3);
        String[] nonRollBackFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(instDef);
        if (nonRollBackFields != null && nonRollBackFields.length > 0) {
            String sNonRollbackFields = null;
            for (int i = 0; i < nonRollBackFields.length; ++i) {
                sNonRollbackFields = sNonRollbackFields == null ? nonRollBackFields[i] : sNonRollbackFields + ", " + nonRollBackFields[i];
            }
            this.appendTextLine(buffer, sNonRollbackFields, 4);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 4);
        }
    }

    private void addSuspendTimerInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String sSuspendTimer = VWInstruction.SuspendTimerInstructionGetTime(instDef);
        if (sSuspendTimer != null && sSuspendTimer.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sSuspendTimer, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_htmlNone, 3);
        }
    }

    private void addWaitForConditionInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        String strText = null;
        VWEventDefinition[] eventDefs = VWInstruction.WaitForEventInstructionGetEvents(instDef);
        if (eventDefs != null && eventDefs.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_conditions), 3);
            for (int i = 0; i < eventDefs.length; ++i) {
                String sMap;
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_workflowName) + eventDefs[i].getWorkClassName(), 3);
                String sCondition = eventDefs[i].getValue();
                if (sCondition != null && sCondition.length() > 0) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_condition) + sCondition, 3);
                } else {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_condition) + VWResource.s_htmlNone, 3);
                }
                String[][] assignments = eventDefs[i].getAssignments();
                if (assignments != null && assignments.length > 0) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_assignments), 3);
                    this.appendTableLine(buffer, null, 1);
                    String[] names = new String[]{VWResource.s_name, VWResource.s_expression};
                    this.appendTableLine(buffer, names, 2);
                    for (int j = 0; j < assignments.length; ++j) {
                        names[0] = assignments[j][0];
                        names[1] = VWStringUtils.toXMLString(assignments[j][1], true);
                        this.appendTableLine(buffer, names, 3);
                    }
                    this.appendTableLine(buffer, null, 5);
                } else {
                    this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
                }
                String sOperator = eventDefs[i].getComparisonOperator();
                if (sOperator != null && sOperator.length() > 0) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_comparisonOperator) + "\"" + sOperator + "\"", 3);
                }
                if ((sMap = eventDefs[i].getCallISName()) != null && sMap.length() > 0) {
                    this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_map) + sMap, 3);
                    continue;
                }
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_map) + VWResource.s_htmlNone, 3);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_conditions) + VWResource.s_htmlNone, 3);
        }
        String sTimeout = VWInstruction.WaitForEventInstructionGetTimeOut(instDef);
        if (sTimeout.equals("0")) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeout) + VWResource.s_htmlNone, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeout) + sTimeout, 3);
        }
        strText = VWInstruction.WaitForEventInstructionGetEventNumLoc(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_conditionResultDataField) + strText, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_conditionResultDataField) + VWResource.s_htmlNone, 3);
        }
    }

    private void addInvokeInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        VWWebServiceParameterDefinition wsParamDef;
        int i;
        String[] names;
        VWInvokeInstruction invoke = (VWInvokeInstruction)instDef;
        String text = invoke.getPartnerLinkName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 2);
        text = invoke.getOperationName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 2);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_outgoingParameters), 2);
        VWWebServiceParameterDefinition[] wsParamDefs = invoke.getOutGoingParameterDefinitions();
        if (wsParamDefs != null && wsParamDefs.length > 1) {
            this.appendTableLine(buffer, null, 1);
            names = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (i = 1; i < wsParamDefs.length; ++i) {
                wsParamDef = wsParamDefs[i];
                names[0] = wsParamDef.getName();
                names[1] = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                names[2] = VWStringUtils.toXMLString(wsParamDef.getValue(), true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_incomingParameters), 2);
        wsParamDefs = invoke.getInComingParameterDefinitions();
        if (wsParamDefs != null && wsParamDefs.length > 1) {
            this.appendTableLine(buffer, null, 1);
            names = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (i = 1; i < wsParamDefs.length; ++i) {
                wsParamDef = wsParamDefs[i];
                names[0] = wsParamDef.getName();
                names[1] = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                names[2] = VWStringUtils.toXMLString(wsParamDef.getValue(), true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_outgoingMessage), 2);
        text = invoke.getInputMsgExpr();
        if (text != null && text.length() > 0) {
            this.appendTextLine(buffer, text, 3);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 2);
        }
        text = invoke.getOutputMsgExpr();
        if (text != null && text.length() > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_incomingXMLDataField) + text, 2);
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_incomingXMLDataField) + VWResource.s_htmlNone, 2);
        }
        text = invoke.getTimeoutExpr();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeoutExpression) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 2);
        text = invoke.getTimeoutMapName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeoutMap) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 2);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_specialFaults), 2);
        VWFaultDefinition[] faults = invoke.getFaults();
        if (faults != null && faults.length > 0) {
            this.appendTableLine(buffer, null, 1);
            String[] names2 = new String[]{VWResource.s_name, VWResource.s_xmlDataField, VWResource.s_submap};
            this.appendTableLine(buffer, names2, 2);
            for (int i2 = 1; i2 < wsParamDefs.length; ++i2) {
                VWFaultDefinition fault = faults[i2];
                names2[0] = fault.getName();
                names2[1] = fault.getFaultMessage();
                names2[2] = fault.getFaultMapName();
                this.appendTableLine(buffer, names2, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_otherFaults), 2);
        text = invoke.getCatchAllMessage();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_xmlDataField) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = invoke.getCatchAllMap();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_submap) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_correlationSet), 2);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_incomingMessage), 3);
        text = invoke.getOutputCorrelationSetName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        String[][] outputCorrelationSets = invoke.getOutputCorrelationSetProperties();
        if (outputCorrelationSets != null && outputCorrelationSets.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties), 4);
            for (int i3 = 0; i3 < outputCorrelationSets.length; ++i3) {
                this.appendTextLine(buffer, i3 + 1 + ". " + outputCorrelationSets[i3][0], 5);
                text = outputCorrelationSets[i3][1];
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 6);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_htmlNone, 4);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_outgoingMessage), 3);
        text = invoke.getInputCorrelationSetName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        String[][] inputCorrelationSets = invoke.getInputCorrelationSetProperties();
        if (inputCorrelationSets != null && inputCorrelationSets.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties), 4);
            for (int i4 = 0; i4 < inputCorrelationSets.length; ++i4) {
                this.appendTextLine(buffer, i4 + 1 + ". " + inputCorrelationSets[i4][0], 5);
                text = inputCorrelationSets[i4][1];
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 6);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_htmlNone, 4);
        }
    }

    private void addReceiveInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        int i;
        String[] names;
        VWReceiveInstruction receive = (VWReceiveInstruction)instDef;
        String text = receive.getPartnerLinkName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = receive.getOperationName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operationParameters), 3);
        VWWebServiceParameterDefinition[] wsParamDefs = receive.getParameterDefinitions();
        if (wsParamDefs != null && wsParamDefs.length > 1) {
            this.appendTableLine(buffer, null, 1);
            names = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (int i2 = 1; i2 < wsParamDefs.length; ++i2) {
                VWWebServiceParameterDefinition wsParamDef = wsParamDefs[i2];
                names[0] = wsParamDef.getName();
                names[1] = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                names[2] = VWStringUtils.toXMLString(wsParamDef.getValue(), true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
        text = receive.getMessageExpr();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_incomingXMLDataField) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = receive.getMessageFromSchemaName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_schema) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = receive.getMessageFromElementName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_element) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = receive.getTimeoutExpr();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeoutExpression) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = receive.getTimeoutMapName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_timeoutMap) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        text = receive.getAuthentication() ? VWResource.s_yes : VWResource.s_no;
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_authentication) + text, 4);
        names = receive.getSecurityGroup();
        if (names == null) {
            this.appendTextLine(buffer, VWResource.s_acceptMessagesFrom + VWResource.s_none, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_acceptMessagesFrom, 5);
            String sNames = null;
            for (int i3 = 0; i3 < names.length; ++i3) {
                sNames = sNames == null ? names[i3] : sNames + ", " + names[i3];
            }
            this.appendTextLine(buffer, sNames, 6);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_correlationSet), 4);
        int id = receive.getCorrelationParameterSequenceNumber();
        wsParamDefs = receive.getParameterDefinitions();
        if (wsParamDefs != null && wsParamDefs.length > 0) {
            boolean found = false;
            for (i = 0; i < wsParamDefs.length; ++i) {
                if (wsParamDefs[i].getSequenceNumber() != id) continue;
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + wsParamDefs[i].getName(), 4);
                found = true;
                break;
            }
            if (!found) {
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + VWResource.s_htmlNone, 4);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + VWResource.s_htmlNone, 4);
        }
        text = receive.getCorrelationValueExpression();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_correlationExpression) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        text = receive.getCorrelationSetName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        String[][] outputCorrelationSets = receive.getCorrelationSetProperties();
        if (outputCorrelationSets != null && outputCorrelationSets.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties), 4);
            for (i = 0; i < outputCorrelationSets.length; ++i) {
                this.appendTextLine(buffer, i + 1 + ". " + outputCorrelationSets[i][0], 5);
                text = outputCorrelationSets[i][1];
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 6);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_htmlNone, 4);
        }
    }

    private void addReplyInstruction(StringBuffer buffer, VWInstructionDefinition instDef) throws Exception {
        int i;
        VWReplyInstruction reply = (VWReplyInstruction)instDef;
        String text = reply.getPartnerLinkName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        text = reply.getOperationName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        VWWebServiceParameterDefinition[] wsParamDefs = reply.getParameterDefinitions();
        if (wsParamDefs != null && wsParamDefs.length > 1) {
            this.appendTableLine(buffer, null, 1);
            String[] names = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_expression};
            this.appendTableLine(buffer, names, 2);
            for (i = 1; i < wsParamDefs.length; ++i) {
                VWWebServiceParameterDefinition wsParamDef = wsParamDefs[i];
                names[0] = wsParamDef.getName();
                names[1] = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                names[2] = VWStringUtils.toXMLString(wsParamDef.getValue(), true);
                this.appendTableLine(buffer, names, 3);
            }
            this.appendTableLine(buffer, null, 5);
        } else {
            this.appendTextLine(buffer, VWResource.s_htmlNone, 3);
        }
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_outgoingMessage), 3);
        text = reply.getMessageExpr();
        this.appendTextLine(buffer, text != null && text.length() > 0 ? text : VWResource.s_htmlNone, 4);
        text = reply.getMessageFromSchemaName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_schema) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = reply.getMessageFromElementName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_element) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        text = reply.getFaultName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_faultName) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 3);
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_correlationSet), 4);
        text = reply.getCorrelationSetName();
        this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 4);
        String[][] outputCorrelationSets = reply.getCorrelationSetProperties();
        if (outputCorrelationSets != null && outputCorrelationSets.length > 0) {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties), 4);
            for (i = 0; i < outputCorrelationSets.length; ++i) {
                this.appendTextLine(buffer, i + 1 + ". " + outputCorrelationSets[i][0], 5);
                text = outputCorrelationSets[i][1];
                this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_htmlNone), 6);
            }
        } else {
            this.appendTextLine(buffer, VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_htmlNone, 4);
        }
    }
}

